/*
 * Decompiled with CFR 0.152.
 */
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;

public class RandomMobs {
    private static Map textureVariantsMap = new HashMap();
    private static bfs renderGlobal = null;
    private static boolean initialized = false;
    private static Random random = new Random();
    private static Field fieldEntityUuid = RandomMobs.getField(pl.class, UUID.class);
    private static boolean working = false;

    public static void entityLoaded(pl entity) {
        if (!(entity instanceof pt)) {
            return;
        }
        pt el2 = (pt)entity;
        lf ws = Config.getWorldServer();
        if (ws == null) {
            return;
        }
        pl es = ws.a(entity.F());
        if (!(es instanceof pt)) {
            return;
        }
        pt els = (pt)es;
        if (fieldEntityUuid != null) {
            try {
                Object uuid = fieldEntityUuid.get((Object)els);
                fieldEntityUuid.set((Object)el2, uuid);
            }
            catch (Exception e2) {
                e2.printStackTrace();
                fieldEntityUuid = null;
            }
        }
    }

    private static Field getField(Class cls, Class fieldType) {
        try {
            Field[] fields = cls.getDeclaredFields();
            for (int i2 = 0; i2 < fields.length; ++i2) {
                Field field = fields[i2];
                Class<?> type = field.getType();
                if (type != fieldType) continue;
                field.setAccessible(true);
                return field;
            }
            return null;
        }
        catch (Exception e2) {
            e2.printStackTrace();
            return null;
        }
    }

    public static void worldChanged(adn oldWorld, adn newWorld) {
        if (newWorld != null) {
            List entityList = newWorld.E();
            for (int e2 = 0; e2 < entityList.size(); ++e2) {
                pl entity = (pl)entityList.get(e2);
                RandomMobs.entityLoaded(entity);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static jz getTextureLocation(jz loc) {
        if (working) {
            return loc;
        }
        try {
            working = true;
            if (!initialized) {
                RandomMobs.initialize();
            }
            if (renderGlobal == null) {
                jz jz2 = loc;
                return jz2;
            }
            pl entity = RandomMobs.renderGlobal.renderedEntity;
            if (entity == null) {
                jz jz3 = loc;
                return jz3;
            }
            if (!(entity instanceof pt)) {
                jz jz4 = loc;
                return jz4;
            }
            String name = loc.a();
            if (!name.startsWith("textures/entity/")) {
                jz jz5 = loc;
                return jz5;
            }
            long uuidLow = entity.aK().getLeastSignificantBits();
            int id = (int)(uuidLow & Integer.MAX_VALUE);
            jz jz6 = RandomMobs.getTextureLocation(loc, id);
            return jz6;
        }
        finally {
            working = false;
        }
    }

    private static jz getTextureLocation(jz loc, int randomId) {
        if (randomId <= 0) {
            return loc;
        }
        String name = loc.a();
        jz[] texLocs = (jz[])textureVariantsMap.get(name);
        if (texLocs == null) {
            texLocs = RandomMobs.getTextureVariants(loc);
            textureVariantsMap.put(name, texLocs);
        }
        if (texLocs == null || texLocs.length <= 0) {
            return loc;
        }
        int index = randomId % texLocs.length;
        jz texLoc = texLocs[index];
        return texLoc;
    }

    private static jz[] getTextureVariants(jz loc) {
        TextureUtils.getTexture(loc);
        jz[] texLocs = new jz[]{};
        String name = loc.a();
        int pointPos = name.lastIndexOf(46);
        if (pointPos < 0) {
            return texLocs;
        }
        String prefix = name.substring(0, pointPos);
        String suffix = name.substring(pointPos);
        String texEntStr = "textures/entity/";
        if (!prefix.startsWith(texEntStr)) {
            return texLocs;
        }
        prefix = prefix.substring(texEntStr.length());
        prefix = "mcpatcher/mob/" + prefix;
        int countVariants = RandomMobs.getCountTextureVariants(prefix, suffix);
        if (countVariants <= 1) {
            return texLocs;
        }
        texLocs = new jz[countVariants];
        texLocs[0] = loc;
        for (int i2 = 1; i2 < texLocs.length; ++i2) {
            int texNum = i2 + 1;
            String texName = prefix + texNum + suffix;
            texLocs[i2] = new jz(loc.b(), texName);
            TextureUtils.getTexture(texLocs[i2]);
        }
        Config.dbg("RandomMobs: " + loc + ", variants: " + texLocs.length);
        return texLocs;
    }

    private static int getCountTextureVariants(String prefix, String suffix) {
        int maxNum = 1000;
        for (int num = 2; num < maxNum; ++num) {
            String variant = prefix + num + suffix;
            jz loc = new jz(variant);
            if (Config.hasResource(loc)) continue;
            return num - 1;
        }
        return maxNum;
    }

    public static void resetTextures() {
        textureVariantsMap.clear();
        if (Config.isRandomMobs()) {
            RandomMobs.initialize();
        }
    }

    private static void initialize() {
        renderGlobal = Config.getRenderGlobal();
        if (renderGlobal == null) {
            return;
        }
        initialized = true;
        ArrayList<String> list = new ArrayList<String>();
        list.add("bat");
        list.add("blaze");
        list.add("cat/black");
        list.add("cat/ocelot");
        list.add("cat/red");
        list.add("cat/siamese");
        list.add("chicken");
        list.add("cow/cow");
        list.add("cow/mooshroom");
        list.add("creeper/creeper");
        list.add("enderman/enderman");
        list.add("enderman/enderman_eyes");
        list.add("ghast/ghast");
        list.add("ghast/ghast_shooting");
        list.add("iron_golem");
        list.add("pig/pig");
        list.add("sheep/sheep");
        list.add("sheep/sheep_fur");
        list.add("silverfish");
        list.add("skeleton/skeleton");
        list.add("skeleton/wither_skeleton");
        list.add("slime/slime");
        list.add("slime/magmacube");
        list.add("snowman");
        list.add("spider/cave_spider");
        list.add("spider/spider");
        list.add("spider_eyes");
        list.add("squid");
        list.add("villager/villager");
        list.add("villager/butcher");
        list.add("villager/farmer");
        list.add("villager/librarian");
        list.add("villager/priest");
        list.add("villager/smith");
        list.add("wither/wither");
        list.add("wither/wither_armor");
        list.add("wither/wither_invulnerable");
        list.add("wolf/wolf");
        list.add("wolf/wolf_angry");
        list.add("wolf/wolf_collar");
        list.add("wolf/wolf_tame");
        list.add("zombie_pigman");
        list.add("zombie/zombie");
        list.add("zombie/zombie_villager");
        for (int i2 = 0; i2 < list.size(); ++i2) {
            String name = (String)list.get(i2);
            String tex = "textures/entity/" + name + ".png";
            jz texLoc = new jz(tex);
            if (!Config.hasResource(texLoc)) {
                Config.warn("Not found: " + texLoc);
            }
            RandomMobs.getTextureLocation(texLoc, 100);
        }
    }
}

