/*
 * Decompiled with CFR 0.152.
 */
import java.util.BitSet;
import java.util.List;

public class RenderEnv {
    private adr blockAccess;
    private ama blockState;
    private ck blockPos;
    private avi gameSettings;
    private int blockId = -1;
    private int metadata = -1;
    private int breakingAnimation = -1;
    private float[] quadBounds = new float[cr.n.length * 2];
    private BitSet boundsFlags = new BitSet(3);
    private bgg.b aoFace = new bgg.b();
    private BlockPosM colorizerBlockPos = null;
    private boolean[] borderFlags = null;
    private static ThreadLocal threadLocalInstance = new ThreadLocal();

    private RenderEnv(adr blockAccess, ama blockState, ck blockPos) {
        this.blockAccess = blockAccess;
        this.blockState = blockState;
        this.blockPos = blockPos;
        this.gameSettings = Config.getGameSettings();
    }

    public static RenderEnv getInstance(adr blockAccessIn, ama blockStateIn, ck blockPosIn) {
        RenderEnv re = (RenderEnv)threadLocalInstance.get();
        if (re == null) {
            re = new RenderEnv(blockAccessIn, blockStateIn, blockPosIn);
            threadLocalInstance.set(re);
            return re;
        }
        re.reset(blockAccessIn, blockStateIn, blockPosIn);
        return re;
    }

    private void reset(adr blockAccessIn, ama blockStateIn, ck blockPosIn) {
        this.blockAccess = blockAccessIn;
        this.blockState = blockStateIn;
        this.blockPos = blockPosIn;
        this.blockId = -1;
        this.metadata = -1;
        this.breakingAnimation = -1;
        this.boundsFlags.clear();
    }

    public int getBlockId() {
        if (this.blockId < 0) {
            this.blockId = afi.a((afi)this.blockState.c());
        }
        return this.blockId;
    }

    public int getMetadata() {
        if (this.metadata < 0) {
            this.metadata = this.blockState.c().c(this.blockState);
        }
        return this.metadata;
    }

    public float[] getQuadBounds() {
        return this.quadBounds;
    }

    public BitSet getBoundsFlags() {
        return this.boundsFlags;
    }

    public bgg.b getAoFace() {
        return this.aoFace;
    }

    public boolean isBreakingAnimation(List listQuads) {
        if (this.breakingAnimation < 0 && listQuads.size() > 0) {
            this.breakingAnimation = listQuads.get(0) instanceof bgo ? 1 : 0;
        }
        return this.breakingAnimation == 1;
    }

    public boolean isBreakingAnimation(bgh quad) {
        if (this.breakingAnimation < 0) {
            this.breakingAnimation = quad instanceof bgo ? 1 : 0;
        }
        return this.breakingAnimation == 1;
    }

    public boolean isBreakingAnimation() {
        return this.breakingAnimation == 1;
    }

    public ama getBlockState() {
        return this.blockState;
    }

    public BlockPosM getColorizerBlockPos() {
        if (this.colorizerBlockPos == null) {
            this.colorizerBlockPos = new BlockPosM(0, 0, 0);
        }
        return this.colorizerBlockPos;
    }

    public boolean[] getBorderFlags() {
        if (this.borderFlags == null) {
            this.borderFlags = new boolean[4];
        }
        return this.borderFlags;
    }
}

