/*
 * Decompiled with CFR 0.152.
 */
import java.util.List;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

public class TMIController {
    public static final String COPYRIGHT = "Copyright 2011-2014 Marglyph. Free for personal or educational use only. Do not redistribute TooManyItems, including in mod packs, and do not use TooManyItems' source code or graphics in your own mods.";
    private boolean once = false;
    private boolean isOpen = false;
    private int savedScreenWidth = 0;
    private int savedScreenHeight = 0;
    private int savedGuiWidth = 0;
    private int savedGuiHeight = 0;
    private TMIArea sidebar = new TMISidebar();
    private boolean skipMouseUpOnce = false;

    public void onCreate(byl byl2) {
        TMITickEntity.create();
        TMIConfigFile.read();
        TMISaveFile.read();
    }

    public void frameStart(int n, int n2, int n3, int n4, int n5, int n6) {
        try {
            if (!TMIConfigFile.isEnabled()) {
                return;
            }
            bxf bxf2 = bsu.z().m;
            if (bxf2 instanceof byz) {
                bul bul2 = (bul)TMIPrivate.creativeSearchBox.get(bxf2);
                bul2.a = n3 + 82;
            }
            int n7 = bsu.z().m.l;
            int n8 = bsu.z().m.m;
            if (n7 != this.savedScreenWidth || n8 != this.savedScreenHeight || n5 != this.savedGuiWidth || n6 != this.savedGuiHeight) {
                this.savedScreenWidth = n7;
                this.savedScreenHeight = n8;
                this.savedGuiWidth = n5;
                this.savedGuiHeight = n6;
                int n9 = (n7 - n5) / 2;
                this.sidebar.setSize(Math.min(175, n9 - 4), Math.min(340, n8 - 8));
                this.sidebar.setPosition(n7 - n9 + 2, (n8 - this.sidebar.getHeight()) / 2);
                this.sidebar.doLayout();
            }
            TMIDispatch.determineMouseover(this.sidebar, n, n2);
        }
        catch (Throwable throwable) {
            TMIDebug.reportExceptionWithTimeout(throwable, 10000L);
        }
    }

    public void frameEnd(int n, int n2, int n3, int n4, int n5, int n6) {
        if (!TMIConfigFile.isEnabled()) {
            return;
        }
        GL11.glPushMatrix();
        GL11.glTranslatef((float)(-((float)n3)), (float)(-((float)n4)), (float)0.0f);
        try {
            List<String> list;
            this.sidebar.draw(n, n2);
            TMIArea tMIArea = this.sidebar.getMouseoverArea();
            if (tMIArea != null && (list = tMIArea.getTooltip()) != null && list.size() > 0) {
                TMIDrawing.drawTooltip(n, n2, list);
            }
        }
        catch (Throwable throwable) {
            TMIDebug.reportExceptionWithTimeout(throwable, 10000L);
        }
        GL11.glPopMatrix();
        GL11.glEnable((int)2896);
        GL11.glEnable((int)2929);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public void onClose() {
        this.sidebar.blurFocused();
    }

    public boolean onClick(int n, int n2, int n3, boolean bl, ajk ajk2, aib aib2) {
        try {
            if (!TMIConfigFile.isEnabled()) {
                return true;
            }
            this.sidebar.blurFocused();
            TMIEvent tMIEvent = TMIEvent.clickEvent(n, n2, n3);
            TMIDispatch.sendMouseEvent(tMIEvent, this.sidebar);
            if (!tMIEvent.cancel && n3 == 0) {
                try {
                    bxf bxf2 = bsu.z().m;
                    if (bxf2 instanceof byz) {
                        bul bul2 = (bul)TMIPrivate.creativeSearchBox.get(bxf2);
                        bul2.b(true);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.skipMouseUpOnce = tMIEvent.cancel;
            return !tMIEvent.cancel;
        }
        catch (Throwable throwable) {
            TMIDebug.reportException(throwable);
            return true;
        }
    }

    public boolean onKeypress(char c, int n) {
        try {
            if (!TMIConfigFile.isEnabled()) {
                if (n == TMIConfigFile.getHotkey()) {
                    TMIConfigFile.toggleEnabled();
                    return false;
                }
                return true;
            }
            TMIEvent tMIEvent = TMIEvent.keypressEvent(c, n);
            TMIDispatch.sendKeypress(tMIEvent, this.sidebar);
            if (!tMIEvent.cancel && n == TMIConfigFile.getHotkey()) {
                TMIConfigFile.toggleEnabled();
                return false;
            }
            return !tMIEvent.cancel;
        }
        catch (Throwable throwable) {
            TMIDebug.reportException(throwable);
            return true;
        }
    }

    public void onMouseEvent() {
        try {
            if (!TMIConfigFile.isEnabled()) {
                return;
            }
            int n = Mouse.getEventDWheel();
            if (n == 0) {
                return;
            }
            n = n < 0 ? -1 : 1;
            bxf bxf2 = bsu.z().m;
            int n2 = Mouse.getEventX() * bxf2.l / bsu.z().d;
            int n3 = bxf2.m - Mouse.getEventY() * bxf2.m / bsu.z().e - 1;
            TMIEvent tMIEvent = TMIEvent.scrollEvent(n2, n3, n);
            TMIDispatch.sendMouseEvent(tMIEvent, this.sidebar);
            if (tMIEvent.cancel) {
                TMIPrivate.lwjglMouseEventDWheel.setInt(null, 0);
                TMIPrivate.lwjglMouseDWheel.setInt(null, 0);
            }
        }
        catch (Throwable throwable) {
            TMIDebug.reportException(throwable);
        }
    }

    public boolean shouldPauseGame() {
        return false;
    }

    public boolean skipMouseUpOnce() {
        boolean bl = this.skipMouseUpOnce;
        this.skipMouseUpOnce = false;
        return bl;
    }
}

