/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.lwjgl.input.Keyboard;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TMIConfig {
    public static final String COPYRIGHT = "All of TooManyItems except for thesmall portion excerpted from the original Minecraft game is copyright 2011Marglyph. TooManyItems is free for personal use only. Do not redistributeTooManyItems, including in mod packs, and do not use TooManyItems' sourcecode or graphics in your own mods.";
    public static final String VERSION = "1.7.10 2014-07-15";
    public static final int NUM_SAVES = 7;
    public static final int INVENTORY_SIZE = 44;
    public static boolean isModloaderEnabled;
    public static boolean isForgeEnabled;
    private static TMIConfig instance;
    private static List<add> items;
    private static List<adb> enchantableItems;
    private static List<add> favorites;
    private static HashSet<Integer> toolIds;
    private static HashSet<Integer> nonUnlimitedIds;
    private Map<String, String> settings = new LinkedHashMap<String, String>();
    private static add[][] states;
    public static boolean[] statesSaved;

    public TMIConfig() {
        this.settings.put("enable", "true");
        this.settings.put("enablemp", "true");
        this.settings.put("itemsonly", "false");
        this.settings.put("give-command", "/give {0} {1} {2} {3}");
        this.settings.put("give-command-num-id", "false");
        this.settings.put("key", "o");
        for (int i = 0; i < this.getNumSaves(); ++i) {
            this.settings.put("save-name" + (i + 1), "" + (i + 1));
        }
        this.settings.put("replace-items", "true");
        instance = this;
    }

    public static boolean isMultiplayer() {
        return !bao.B().G();
    }

    public static TMIConfig getInstance() {
        if (instance == null) {
            new TMIConfig();
        }
        return instance;
    }

    public Map<String, String> getSettings() {
        return this.settings;
    }

    public List<add> getItems() {
        return items;
    }

    public List<adb> getEnchantableItems() {
        return enchantableItems;
    }

    public int getHotkey() {
        String string = this.settings.get("key");
        int n = 0;
        n = Keyboard.getKeyIndex((String)string.toUpperCase());
        if (n == 0) {
            n = 24;
        }
        return n;
    }

    public int getNumSaves() {
        return 7;
    }

    public boolean isStateSaved(int n) {
        return statesSaved[n];
    }

    public add[] getState(int n) {
        return states[n];
    }

    public boolean getBooleanSetting(String string) {
        return Boolean.parseBoolean(this.settings.get(string));
    }

    public boolean isEnabled() {
        return TMIConfig.isMultiplayer() && this.getBooleanSetting("enablemp") || !TMIConfig.isMultiplayer() && this.getBooleanSetting("enable");
    }

    public void toggleEnabled() {
        String string = TMIConfig.isMultiplayer() ? "enablemp" : "enable";
        this.settings.put(string, Boolean.toString(!this.getBooleanSetting(string)));
    }

    public void setEnabled(boolean bl) {
        String string = TMIConfig.isMultiplayer() ? "enablemp" : "enable";
        this.settings.put(string, Boolean.toString(bl));
    }

    public static boolean isTool(adb adb2) {
        return toolIds.contains(TMISnapshotUtil.idForItem(adb2));
    }

    public static boolean isTool(int n) {
        return toolIds.contains(n);
    }

    public static boolean canItemBeUnlimited(adb adb2) {
        return !nonUnlimitedIds.contains(TMISnapshotUtil.idForItem(adb2));
    }

    public boolean areDamageVariantsShown() {
        if (TMIConfig.isMultiplayer()) {
            String string = this.getSettings().get("give-command");
            return string.contains("{3}");
        }
        return true;
    }

    public void clearState(int n) {
        for (int i = 0; i < 44; ++i) {
            TMIConfig.states[n][i] = null;
            TMIConfig.statesSaved[n] = false;
        }
        this.settings.put("save" + (n + 1), "");
    }

    public void loadState(int n) {
        int n2;
        if (!statesSaved[n]) {
            return;
        }
        try {
            if (bao.B().n instanceof bfl) {
                TMIPrivateFields.setCreativeTab.invoke((Object)((bfl)bao.B().n), abt.m);
            }
        }
        catch (Exception exception) {
            System.out.println(exception);
        }
        add[] addArray = TMIUtils.getPlayer().bm.a;
        add[] addArray2 = TMIUtils.getPlayer().bm.b;
        for (n2 = 0; n2 < 4; ++n2) {
            addArray2[n2] = TMIUtils.copyStack(states[n][n2 + 4]);
        }
        for (n2 = 0; n2 < 27; ++n2) {
            addArray[n2 + 9] = TMIUtils.copyStack(states[n][n2 + 8]);
        }
        for (n2 = 0; n2 < 9; ++n2) {
            addArray[n2] = TMIUtils.copyStack(states[n][n2 + 8 + 27]);
        }
    }

    public void saveState(int n) {
        int n2;
        add[] addArray = TMIUtils.getPlayer().bm.a;
        add[] addArray2 = TMIUtils.getPlayer().bm.b;
        for (n2 = 0; n2 < 4; ++n2) {
            TMIConfig.states[n][n2 + 4] = TMIUtils.copyStack(addArray2[n2]);
        }
        for (n2 = 0; n2 < 27; ++n2) {
            TMIConfig.states[n][n2 + 8] = TMIUtils.copyStack(addArray[n2 + 9]);
        }
        for (n2 = 0; n2 < 9; ++n2) {
            TMIConfig.states[n][n2 + 8 + 27] = TMIUtils.copyStack(addArray[n2]);
        }
        this.settings.put("save" + (n + 1), this.encodeState(n));
        TMIConfig.statesSaved[n] = true;
    }

    public String encodeState(int n) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < 44; ++i) {
            if (states[n][i] != null) {
                stringBuilder.append(TMISnapshotUtil.idForStack(states[n][i]));
                stringBuilder.append(":");
                stringBuilder.append(TMIConfig.states[n][i].b);
                stringBuilder.append(":");
                stringBuilder.append(states[n][i].j());
                List<int[]> list = TMIUtils.getEnchantments(states[n][i]);
                for (int[] nArray : list) {
                    int n2 = nArray[0];
                    int n3 = nArray[1];
                    stringBuilder.append(":" + n2 + ":" + n3);
                }
            }
            stringBuilder.append(",");
        }
        return stringBuilder.toString();
    }

    public void decodeState(int n, String string) {
        if (string.trim().equals("")) {
            TMIConfig.statesSaved[n] = false;
        } else {
            String[] stringArray = string.split(",", 0);
            for (int i = 0; i < stringArray.length && i < states[n].length; ++i) {
                String[] stringArray2 = stringArray[i].split(":");
                if (stringArray2.length < 3) continue;
                try {
                    TMIConfig.states[n][i] = TMISnapshotUtil.createStack(Integer.parseInt(stringArray2[0]), Integer.parseInt(stringArray2[2]), Integer.parseInt(stringArray2[1]));
                    for (int j = 3; j < stringArray2.length - 1; j += 2) {
                        int n2 = Integer.parseInt(stringArray2[j]);
                        int n3 = Integer.parseInt(stringArray2[j + 1]);
                        TMIUtils.addEnchantment(states[n][i], n2, n3);
                    }
                    continue;
                }
                catch (Exception exception) {
                    System.out.println(exception);
                }
            }
            TMIConfig.statesSaved[n] = true;
        }
    }

    public List<add> getFavorites() {
        return favorites;
    }

    public void decodeFavorites() {
        String[] stringArray;
        favorites.clear();
        for (String string : stringArray = this.settings.get("favorites").trim().split(",", 0)) {
            String[] stringArray2 = string.split(":");
            if (stringArray2.length < 2) continue;
            try {
                int n = Integer.parseInt(stringArray2[0]);
                int n2 = Integer.parseInt(stringArray2[1]);
                add add2 = TMISnapshotUtil.createStack(n, n2);
                for (int i = 2; i < stringArray2.length - 1; i += 2) {
                    int n3 = Integer.parseInt(stringArray2[i]);
                    int n4 = Integer.parseInt(stringArray2[i + 1]);
                    TMIUtils.addEnchantment(add2, n3, n4);
                }
                favorites.add(add2);
            }
            catch (Exception exception) {
                System.out.println(exception);
            }
        }
    }

    public void encodeFavorites() {
        StringBuilder stringBuilder = new StringBuilder();
        for (add add2 : favorites) {
            stringBuilder.append(TMISnapshotUtil.idForStack(add2));
            stringBuilder.append(":");
            stringBuilder.append(add2.j());
            List<int[]> list = TMIUtils.getEnchantments(add2);
            for (int[] nArray : list) {
                int n = nArray[0];
                int n2 = nArray[1];
                stringBuilder.append(":" + n + ":" + n2);
            }
            stringBuilder.append(",");
        }
        this.settings.put("favorites", stringBuilder.toString());
    }

    public static boolean canDelete() {
        return !TMIConfig.isMultiplayer();
    }

    public static boolean canChangeWeather() {
        return !TMIConfig.getInstance().getBooleanSetting("itemsonly");
    }

    public static boolean canChangeCreativeMode() {
        return !TMIConfig.getInstance().getBooleanSetting("itemsonly");
    }

    public static boolean canChangeTime() {
        return !TMIConfig.getInstance().getBooleanSetting("itemsonly");
    }

    public static boolean canChangeHealth() {
        return !TMIConfig.isMultiplayer() && !TMIConfig.getInstance().getBooleanSetting("itemsonly");
    }

    public static boolean canRestoreSaves() {
        return !TMIConfig.isMultiplayer();
    }

    public static boolean canChangeDifficulty() {
        return !TMIConfig.isMultiplayer();
    }

    static {
        int n;
        isModloaderEnabled = false;
        isForgeEnabled = false;
        items = new ArrayList<add>();
        enchantableItems = new ArrayList<adb>();
        favorites = new ArrayList<add>();
        toolIds = new HashSet();
        for (n = 0; n <= 3; ++n) {
            toolIds.add(TMIItemInfo.addItemOffset(n));
        }
        for (n = 11; n <= 23; ++n) {
            toolIds.add(TMIItemInfo.addItemOffset(n));
        }
        for (n = 27; n <= 30; ++n) {
            toolIds.add(TMIItemInfo.addItemOffset(n));
        }
        for (n = 34; n <= 38; ++n) {
            toolIds.add(TMIItemInfo.addItemOffset(n));
        }
        for (n = 42; n <= 61; ++n) {
            toolIds.add(TMIItemInfo.addItemOffset(n));
        }
        toolIds.add(TMIItemInfo.addItemOffset(103));
        toolIds.add(TMIItemInfo.addItemOffset(90));
        toolIds.add(TMIItemInfo.addItemOffset(5));
        nonUnlimitedIds = new HashSet();
        nonUnlimitedIds.add(TMIItemInfo.addItemOffset(102));
        states = new add[7][44];
        statesSaved = new boolean[7];
    }
}

