/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.text.FieldPosition;
import java.text.MessageFormat;
import java.text.Normalizer;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.regex.Pattern;
import net.minecraft.server.MinecraftServer;
import org.lwjgl.input.Keyboard;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TMIUtils {
    public static final String COPYRIGHT = "All of TooManyItems except for thesmall portion excerpted from the original Minecraft game is copyright 2011Marglyph. TooManyItems is free for personal use only. Do not redistributeTooManyItems, including in mod packs, and do not use TooManyItems' sourcecode or graphics in your own mods.";
    public static final String CONFIG_FILENAME = "TooManyItems.txt";
    public static final String NBT_FILENAME = "TMI.nbt";
    public static final int SPAWNER_ID = 52;
    public static final int MODE_SURVIVAL = 0;
    public static final int MODE_CREATIVE = 1;
    public static final int MODE_ADVENTURE = 2;
    public static final List<String> EMPTY_NAME = new ArrayList<String>(){
        {
            this.add("");
        }
    };
    public static final Random random = new Random();
    public static List<add> availableItems = new ArrayList<add>();

    public static File configFile() {
        return new File(bao.B().w, CONFIG_FILENAME);
    }

    public static File nbtFile() {
        return new File(bao.B().w, NBT_FILENAME);
    }

    public static void loadPreferences(TMIConfig tMIConfig) {
        try {
            Map<String, String> map = tMIConfig.getSettings();
            File file = TMIUtils.configFile();
            if (file.exists()) {
                String string;
                if (!TMIUtils.nbtFile().exists()) {
                    map.put("favorites", "");
                    for (int i = 0; i < 7; ++i) {
                        map.put("save" + (i + 1), "");
                    }
                }
                BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
                while ((string = bufferedReader.readLine()) != null) {
                    String[] stringArray = string.split(":", 2);
                    if (stringArray.length <= 1 || !map.containsKey(stringArray[0])) continue;
                    map.put(stringArray[0], stringArray[1]);
                }
                bufferedReader.close();
                if (!TMIUtils.nbtFile().exists()) {
                    for (int i = 0; i < tMIConfig.getNumSaves(); ++i) {
                        if (!map.containsKey("save" + (i + 1))) continue;
                        tMIConfig.decodeState(i, map.get("save" + (i + 1)));
                    }
                    System.out.println("Loading old favorites");
                    tMIConfig.decodeFavorites();
                }
            }
            TMIUtils.loadNBTFile(tMIConfig);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static void savePreferences(TMIConfig tMIConfig) {
        try {
            TMIUtils.saveNBTFile(tMIConfig);
            Map<String, String> map = tMIConfig.getSettings();
            File file = TMIUtils.configFile();
            PrintWriter printWriter = new PrintWriter(new FileWriter(file));
            for (String string : map.keySet()) {
                if (string.matches("favorites|save\\d")) continue;
                printWriter.println(string + ":" + map.get(string));
            }
            printWriter.close();
        }
        catch (Exception exception) {
            System.out.println(exception);
        }
    }

    public static void saveNBTFile(TMIConfig tMIConfig) {
        try {
            dh dh2;
            DataOutputStream dataOutputStream = new DataOutputStream(new FileOutputStream(TMIUtils.nbtFile()));
            dq dq2 = new dq();
            dq dq3 = new dq();
            List<add> list = tMIConfig.getFavorites();
            for (add dq4 : list) {
                dh2 = new dh();
                if (dq4 != null) {
                    dq4.b(dh2);
                }
                dq3.a((dy)dh2);
            }
            dq2.a((dy)dq3);
            for (int i = 0; i < 7; ++i) {
                if (TMIConfig.statesSaved[i]) {
                    add[] addArray = tMIConfig.getState(i);
                    dh2 = new dq();
                    for (int j = 0; j < addArray.length; ++j) {
                        dh dh3 = new dh();
                        if (addArray[j] != null) {
                            addArray[j].b(dh3);
                        }
                        dh2.a((dy)dh3);
                    }
                    dq2.a((dy)dh2);
                    continue;
                }
                dq dq4 = new dq();
                dq2.a((dy)dq4);
            }
            TMIPrivateFields.writeTagList.invoke((Object)dq2, dataOutputStream);
        }
        catch (Exception exception) {
            System.out.println("[TMI] While saving NBT file.");
            System.out.println(exception);
        }
    }

    public static void loadNBTFile(TMIConfig tMIConfig) {
        try {
            add[] addArray;
            dq dq2;
            dy dy2;
            File file = TMIUtils.nbtFile();
            if (!file.exists()) {
                return;
            }
            DataInputStream dataInputStream = new DataInputStream(new FileInputStream(file));
            dq dq3 = new dq();
            TMIPrivateFields.readTagList.invoke((Object)dq3, dataInputStream, 1, new ds(0x200000L));
            List<dy> list = TMISnapshotUtil.getTaglist(dq3);
            int n = 0;
            if (list.size() > 0) {
                List<dy> list2 = TMISnapshotUtil.getTaglist((dq)list.get(0));
                dy2 = tMIConfig.getFavorites();
                dy2.clear();
                dq2 = list2.iterator();
                while (dq2.hasNext()) {
                    addArray = dq2.next();
                    add add2 = TMISnapshotUtil.createStack(1);
                    add2.c((dh)addArray);
                    dy2.add(add2);
                }
            }
            for (int i = 1; i < list.size(); ++i) {
                n = i - 1;
                dy2 = list.get(i);
                if (!(dy2 instanceof dq) || (dq2 = (dq)dy2).c() <= 0 || n >= 7) continue;
                addArray = tMIConfig.getState(n);
                for (int j = 0; j < dq2.c(); ++j) {
                    dh dh2 = dq2.b(j);
                    if (dh2.c("id")) {
                        addArray[j] = TMISnapshotUtil.createStack(1);
                        addArray[j].c(dh2);
                        continue;
                    }
                    addArray[j] = null;
                }
                TMIConfig.statesSaved[n] = true;
            }
        }
        catch (Exception exception) {
            System.out.println("[TMI] While loading NBT");
            exception.printStackTrace();
        }
    }

    public static void loadItems(TMIConfig tMIConfig) {
        Object object;
        Object object2;
        Iterator iterator;
        Serializable serializable;
        List<add> list = availableItems;
        List<adb> list2 = tMIConfig.getEnchantableItems();
        boolean bl = TMIConfig.isMultiplayer();
        list.clear();
        list2.clear();
        try {
            serializable = Class.forName("com.eloraam.redpower.RedPowerBase");
            iterator = (aji)((Class)serializable).getDeclaredField("blockMicro").get(null);
            object2 = aji.class.getDeclaredField("_block_id");
            TMIItemInfo.setMaxDamageException(((Field)object2).getInt(iterator), 32000);
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
        }
        catch (Exception exception) {
            System.out.println(exception);
        }
        serializable = new ArrayList();
        iterator = TMISnapshotUtil.itemIter();
        block11: while (iterator.hasNext()) {
            Iterator<Object> iterator2;
            object2 = (adb)iterator.next();
            if (object2 == null) continue;
            if (TMISnapshotUtil.idForItem((adb)object2) == TMIItemInfo.addItemOffset(127)) {
                if (!tMIConfig.areDamageVariantsShown()) continue;
                iterator2 = sg.a.keySet().iterator();
                while (iterator2.hasNext()) {
                    object = iterator2.next();
                    list.add(TMISnapshotUtil.newStack(TMIItemInfo.addItemOffset(127), 64, (Integer)object));
                }
                continue;
            }
            if (TMISnapshotUtil.idForItem((adb)object2) == 52) {
                if (bl) {
                    list.add(TMISnapshotUtil.newStack(52, 64, 0));
                    continue;
                }
                try {
                    iterator2 = TMIPrivateFields.getSpawnerEntityIdSet().iterator();
                    while (iterator2.hasNext()) {
                        int n = (Integer)iterator2.next();
                        add add2 = TMISnapshotUtil.newStack(52, 64, n);
                        TMICustomItems.nameStack(add2, "\u00a7r" + sg.b((int)n) + " Spawner");
                        list.add(add2);
                    }
                    list.addAll(TMICustomItems.tmiCustomSpawners());
                }
                catch (Exception exception) {
                    System.out.println(exception);
                    list.add(TMISnapshotUtil.newStack(52, 64, 0));
                }
                continue;
            }
            if (TMIItemInfo.isHidden(TMISnapshotUtil.idForItem((adb)object2))) continue;
            if (object2.c() > 0) {
                list2.add((adb)object2);
            }
            if ((iterator2 = TMISnapshotUtil.blockForId(TMISnapshotUtil.idForItem((adb)object2))) != null) {
                serializable.clear();
                iterator2.a((adb)object2, null, (List)((Object)serializable));
                if (serializable.size() > 1) {
                    object = serializable.iterator();
                    while (object.hasNext()) {
                        add add3 = (add)object.next();
                        add3.b = TMISnapshotUtil.maxStack(add3);
                        list.add(add3);
                    }
                    continue;
                }
            }
            object = new HashSet();
            int n = tMIConfig.areDamageVariantsShown() ? 15 : 0;
            int n2 = TMIItemInfo.getMaxDamageException(TMISnapshotUtil.idForItem((adb)object2));
            if (n2 > n) {
                n = n2;
            }
            boolean bl2 = false;
            for (int i = 0; i <= n; ++i) {
                if (TMISnapshotUtil.idForItem((adb)object2) == 43 && i > 0 || TMISnapshotUtil.idForItem((adb)object2) == 44 && i > 5 || TMISnapshotUtil.idForItem((adb)object2) == 59 && (i != 7 || bl) || TMISnapshotUtil.idForItem((adb)object2) == 104 && (i != 7 || bl) || TMISnapshotUtil.idForItem((adb)object2) == 105 && (i != 7 || bl) || TMISnapshotUtil.idForItem((adb)object2) == 115 && (i != 3 || bl) || TMISnapshotUtil.idForItem((adb)object2) == 78 && i > 0 && bl || TMISnapshotUtil.idForItem((adb)object2) == 125 && i > 0 || TMISnapshotUtil.idForItem((adb)object2) == 126 && i > 3) continue;
                add add4 = new add((adb)object2, object2.m(), i);
                try {
                    rf rf2 = object2.j(add4);
                    String string = object2.a(add4);
                    if (TMIUtils.itemDisplayName(add4).equals("Unnamed")) {
                        if (i != 0) continue;
                        continue block11;
                    }
                    if (iterator2 != null) {
                        try {
                            iterator2.b(1, i);
                        }
                        catch (Exception exception) {
                            continue;
                        }
                    }
                    boolean bl3 = !bl && (TMISnapshotUtil.idForItem((adb)object2) == 99 || TMISnapshotUtil.idForItem((adb)object2) == 100) && i < 16;
                    String string2 = string + "@" + rf2.g();
                    if (((HashSet)object).contains(string2) && !TMIItemInfo.isShown(TMISnapshotUtil.idForItem((adb)object2), i) && !bl3) continue;
                    list.add(add4);
                    ((HashSet)object).add(string2);
                    continue;
                }
                catch (NullPointerException nullPointerException) {
                    continue;
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    // empty catch block
                }
            }
        }
        if (tMIConfig.areDamageVariantsShown()) {
            object2 = TMIItemInfo.potionValues.iterator();
            while (object2.hasNext()) {
                int n = (Integer)object2.next();
                object = TMISnapshotUtil.newStack(TMIItemInfo.addItemOffset(117), 64, n);
                list.add((add)object);
            }
        }
        if (tMIConfig.areDamageVariantsShown()) {
            if (!tMIConfig.isMultiplayer()) {
                list.addAll(TMICustomItems.tmiCustomPotions());
                list.addAll(TMICustomItems.tmiCustomFireworks());
            }
        }
        TMIUtils.filterItems(null, tMIConfig);
    }

    public static String deaccent(String string) {
        try {
            Class.forName("java.text.Normalizer");
        }
        catch (ClassNotFoundException classNotFoundException) {
            return string;
        }
        String string2 = Normalizer.normalize(string, Normalizer.Form.NFD);
        Pattern pattern = Pattern.compile("\\p{InCombiningDiacriticalMarks}+");
        return pattern.matcher(string2).replaceAll("");
    }

    public static void filterItems(String string, TMIConfig tMIConfig) {
        List<add> list = availableItems;
        List<add> list2 = tMIConfig.getItems();
        list2.clear();
        if (string == null || string.equals("")) {
            for (add add2 : list) {
                list2.add(add2);
            }
        } else {
            string = TMIUtils.deaccent(string.toLowerCase());
            for (add add3 : list) {
                String string2;
                if (add3 == null || (string2 = TMIUtils.itemDisplayName(add3)) == null || !TMIUtils.deaccent(string2.toLowerCase()).contains(string)) continue;
                list2.add(add3);
            }
        }
    }

    public static void safeReportException(Exception exception) {
        try {
            System.out.println("[TMI] reporting exception to file");
            exception.printStackTrace();
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat(".yyyyMMdd.HHmmss");
            StringBuffer stringBuffer = new StringBuffer();
            simpleDateFormat.format(new Date(), stringBuffer, new FieldPosition(1));
            String string = "tmi" + stringBuffer.toString() + ".txt";
            File file = new File(bao.B().w, string);
            PrintWriter printWriter = new PrintWriter(new FileWriter(file));
            printWriter.print("[code]TMI Version: 1.7.10 2014-07-15\n");
            exception.printStackTrace(printWriter);
            printWriter.println("[/code]");
            printWriter.close();
        }
        catch (Exception exception2) {
            System.out.println("Error during safeReportException:");
            exception2.printStackTrace();
        }
    }

    public static List<String> itemDisplayNameMultiline(add add2, boolean bl) {
        return TMIUtils.itemDisplayNameMultiline(add2, bl, false);
    }

    public static List<String> itemDisplayNameMultiline(add add2, boolean bl, boolean bl2) {
        Object object;
        if (add2 == null) {
            return EMPTY_NAME;
        }
        if (bl2) {
            bl = false;
        }
        List<String> list = null;
        if (TMIUtils.isValidItem(add2)) {
            try {
                object = add2.a((yz)bao.B().h, bl2);
                list = object;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (list == null || list.size() == 0 || TMISnapshotUtil.idForStack(add2) == 52 && add2.d == null) {
            list = new ArrayList<String>();
            list.add(TMIItemInfo.getFallbackName(TMISnapshotUtil.idForStack(add2), add2.j()));
            if (bl2) {
                bl = true;
            }
        }
        if (((String)(object = ((String)list.get(0)).trim())).length() == 0) {
            object = TMIItemInfo.getFallbackName(TMISnapshotUtil.idForStack(add2), add2.j());
            list.set(0, (String)object);
        }
        if (bl && add2 != null) {
            object = (String)object + " " + TMISnapshotUtil.idForStack(add2);
            if (add2.j() != 0) {
                object = (String)object + " : " + add2.j();
            }
            list.set(0, (String)object);
        }
        return list;
    }

    public static String itemDisplayName(add add2) {
        List<String> list = TMIUtils.itemDisplayNameMultiline(add2, false);
        return list.get(0);
    }

    public static boolean isValidItem(add add2) {
        return add2 == null || TMISnapshotUtil.itemForStack(add2) != null;
    }

    public static add getValidItem(add add2) {
        if (TMIUtils.isValidItem(add2)) {
            return add2;
        }
        return TMISnapshotUtil.createStack(52);
    }

    public static String getValidItemDisplayName(add add2) {
        if (TMIUtils.isValidItem(add2)) {
            return TMIUtils.itemDisplayName(add2);
        }
        return "Undefined Item";
    }

    public static void setHeldItem(add add2) {
        TMIUtils.getPlayer().bm.b(add2);
        bao.B().h.bm.b(add2);
    }

    public static void deleteHeldItem() {
        TMIUtils.setHeldItem(null);
    }

    public static add getHeldItem() {
        return bao.B().h.bm.o();
    }

    public static void giveStack(add add2, TMIConfig tMIConfig) {
        TMIUtils.giveStack(add2, tMIConfig, add2.b);
    }

    public static void giveStack(add add2, TMIConfig tMIConfig, int n) {
        add add3 = TMIUtils.copyStack(add2);
        add3.b = n;
        bao bao2 = bao.B();
        if (TMIConfig.isMultiplayer()) {
            NumberFormat numberFormat = NumberFormat.getIntegerInstance();
            numberFormat.setGroupingUsed(false);
            MessageFormat messageFormat = new MessageFormat(tMIConfig.getSettings().get("give-command"));
            boolean bl = tMIConfig.getBooleanSetting("give-command-num-id");
            String string = bl ? "" + TMISnapshotUtil.idForStack(add3) : TMISnapshotUtil.keyForItem(TMISnapshotUtil.itemForStack(add3));
            messageFormat.setFormatByArgumentIndex(2, numberFormat);
            messageFormat.setFormatByArgumentIndex(3, numberFormat);
            Object[] objectArray = new Object[]{bao2.h.b_(), string, add3.b, add3.j()};
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(messageFormat.format(objectArray));
            stringBuilder.append(TMIUtils.tagForGiveCommand(add2));
            bao2.h.a(stringBuilder.toString());
        } else {
            TMIUtils.getPlayer().bm.a(add3);
        }
    }

    public static String tagForGiveCommand(add add2) {
        List<int[]> list = TMIUtils.getEnchantments(add2);
        if (list.size() == 0) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(" {ench:[");
        for (int i = 0; i < list.size(); ++i) {
            int[] nArray = list.get(i);
            if (i > 0) {
                stringBuilder.append(",");
            }
            stringBuilder.append("{id:");
            stringBuilder.append(nArray[0]);
            stringBuilder.append(",lvl:");
            stringBuilder.append(nArray[1]);
            stringBuilder.append("}");
        }
        stringBuilder.append("]}");
        return stringBuilder.toString();
    }

    public static add copyStack(add add2) {
        return add2 == null ? null : add2.m();
    }

    public static void updateUnlimitedItems() {
        try {
            if (TMIConfig.isMultiplayer() || !TMIConfig.getInstance().isEnabled()) {
                return;
            }
            for (add add2 : TMIUtils.getPlayer().bm.a) {
                dh dh2;
                if (add2 == null || add2.d == null || !add2.d.c("TooManyItems") || !(dh2 = add2.d.m("TooManyItems")).c("Unlimited")) continue;
                if (TMIConfig.isTool(TMISnapshotUtil.idForStack(add2))) {
                    add2.b(0);
                    continue;
                }
                int n = TMIUtils.maxStackSize(TMISnapshotUtil.idForStack(add2));
                if (n == 1) {
                    n = 64;
                }
                add2.b = n;
            }
            add add3 = TMIUtils.getHeldItem();
            if (add3 != null && add3.b > 64) {
                add3.b = -1;
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public static void setStackDamage(add add2, int n) {
        try {
            add2.b(n);
        }
        catch (Exception exception) {
            System.out.println("[TMI] Error setting stack damage");
            exception.printStackTrace();
        }
    }

    public static void deleteInventory() {
        List list = TMIUtils.getPlayer().bo.c;
        for (int i = 0; i < list.size(); ++i) {
            aay aay2 = (aay)list.get(i);
            if (aay2 == null) continue;
            aay2.c((add)null);
        }
    }

    public static void deleteItemsOfType(add add2, bex bex2) {
        List list = TMIUtils.getPlayer().bo.c;
        for (int i = 0; i < list.size(); ++i) {
            add add3;
            aay aay2 = (aay)list.get(i);
            if (aay2 == null || (add3 = aay2.d()) == null || TMISnapshotUtil.idForStack(add3) != TMISnapshotUtil.idForStack(add2) || add3.j() != add2.j()) continue;
            aay2.c((add)null);
        }
    }

    public static boolean shiftKey() {
        return Keyboard.isKeyDown((int)54) || Keyboard.isKeyDown((int)42);
    }

    public static int getGameMode() {
        try {
            return ((ahk)TMIPrivateFields.gameMode.get(bao.B().c)).a();
        }
        catch (IllegalAccessException illegalAccessException) {
            System.out.println(illegalAccessException);
            return 0;
        }
    }

    public static void setGameMode(int n) {
        if (TMIConfig.isMultiplayer()) {
            bao.B().h.a("/gamemode " + n);
        } else {
            TMIUtils.getPlayer().a(ahk.a((int)n));
        }
    }

    public static boolean isCreativeMode() {
        return bao.B().c.h();
    }

    public static void setCreativeMode(boolean bl) {
        if (TMIConfig.isMultiplayer()) {
            bao.B().h.a("/gamemode " + (bl ? "1" : "0"));
        } else {
            TMIUtils.getPlayer().a(bl ? ahk.c : ahk.b);
        }
    }

    public static boolean isCreativeSearchTab() {
        return false;
    }

    public static boolean isRaining() {
        return bao.B().f.N().p();
    }

    public static void setRaining(boolean bl) {
        if (TMIConfig.isMultiplayer()) {
            bao.B().h.a("/toggledownfall");
        } else {
            MinecraftServer.I().c[0].N().b(bl);
            MinecraftServer.I().c[0].N().g(bl ? 18000 : 180000);
        }
    }

    public static long getTime() {
        return bao.B().f.N().g();
    }

    public static void setTime(long l) {
        if (TMIConfig.isMultiplayer()) {
            bao.B().h.a("/time set " + l);
        } else {
            MinecraftServer.I().c[0].b(l);
        }
    }

    public static void setHourForward(int n) {
        long l = TMIUtils.getTime() / 24000L * 24000L;
        long l2 = l + 24000L + (long)(n * 1000);
        TMIUtils.setTime(l2);
    }

    public static void logWithTrace(String string) {
        System.out.println(string);
        StackTraceElement[] stackTraceElementArray = Thread.currentThread().getStackTrace();
        for (int i = 0; i < stackTraceElementArray.length; ++i) {
            System.out.println(stackTraceElementArray[i].toString());
        }
    }

    public static void logWithTrace(String string, int n) {
        System.out.println(string);
        StackTraceElement[] stackTraceElementArray = Thread.currentThread().getStackTrace();
        for (int i = 0; i < stackTraceElementArray.length && i < n; ++i) {
            System.out.println(stackTraceElementArray[i].toString());
        }
    }

    public static boolean playerIsAlive() {
        return !bao.B().h.K;
    }

    public static void setPlayerHealth(float f) {
        if (TMIUtils.playerIsAlive()) {
            TMIUtils.getPlayer().g(f);
        }
    }

    public static void fillHunger() {
        if (TMIUtils.playerIsAlive()) {
            TMIUtils.getPlayer().bQ().a(20);
            TMIUtils.getPlayer().bQ().b(5.0f);
        }
    }

    public static void incrementDifficulty() {
        bao.B().u.a(bbm.l, 1);
    }

    public static String getDifficultyString() {
        return bao.B().u.c(bbm.l);
    }

    public static void suppressAchievementNotice() {
        try {
            for (Field field : bao.B().q.getClass().getDeclaredFields()) {
                if (!field.getName().equals("_gui_achievement_time")) continue;
                field.setAccessible(true);
                field.setInt(bao.B().q, 0);
            }
        }
        catch (Exception exception) {
            System.out.println(exception);
        }
    }

    public static int maxStackSize(int n) {
        return TMISnapshotUtil.itemForId(n).m();
    }

    public static List<int[]> getEnchantments(add add2) {
        dq dq2;
        ArrayList<int[]> arrayList = new ArrayList<int[]>();
        if (add2 != null && (dq2 = add2.r()) != null) {
            for (int i = 0; i < dq2.c(); ++i) {
                short s = dq2.b(i).e("id");
                short s2 = dq2.b(i).e("lvl");
                int[] nArray = new int[]{s, s2};
                arrayList.add(nArray);
            }
        }
        return arrayList;
    }

    public static boolean addEnchantment(add add2, int n, int n2) {
        if (n < aft.b.length && aft.b[n] != null) {
            add2.a(aft.b[n], n2);
            return true;
        }
        return false;
    }

    public static dh getTagCompoundWithCreate(add add2, String string) {
        dh dh2;
        if (add2.d == null) {
            add2.d = new dh();
        }
        if (!add2.d.c(string)) {
            dh2 = new dh();
            add2.d.a(string, (dy)dh2);
        } else {
            dh2 = add2.d.m(string);
        }
        return dh2;
    }

    public static mw getPlayer() {
        MinecraftServer minecraftServer = MinecraftServer.I();
        oi oi2 = minecraftServer.ah();
        String string = bao.B().h.b_();
        return oi2.a(string);
    }

    public static boolean isEnchantmentNormallyPossible(aft aft2, adb adb2) {
        return aft2.C.a(adb2) || TMISnapshotUtil.idForItem(adb2) == TMIItemInfo.addItemOffset(147);
    }

    public static boolean isEnchantmentNormallyPossible(aft aft2, add add2) {
        return aft2.C.a(TMISnapshotUtil.itemForId(TMISnapshotUtil.idForStack(add2))) || TMISnapshotUtil.idForStack(add2) == TMIItemInfo.addItemOffset(147);
    }

    public static List<aft> getPossibleEnchantments(adb adb2) {
        if (adb2.c() > 0) {
            ArrayList<aft> arrayList = new ArrayList<aft>();
            for (aft aft2 : aft.b) {
                if (aft2 == null || !aft2.C.a(adb2)) continue;
                arrayList.add(aft2);
            }
            return arrayList;
        }
        return new ArrayList<aft>();
    }

    public static void dumpItemList() {
        try {
            File file = new File(bao.B().w, "TMIItemList.txt");
            PrintWriter printWriter = new PrintWriter(new FileWriter(file));
            for (add add2 : TMIConfig.getInstance().getItems()) {
                printWriter.println("" + TMISnapshotUtil.idForStack(add2) + ":" + add2.j() + " " + TMIUtils.getValidItemDisplayName(add2));
            }
            printWriter.close();
        }
        catch (Exception exception) {
            System.out.println(exception.toString());
        }
    }
}

