/*
 * Decompiled with CFR 0.152.
 */
package redgear.morebackpacks.config;

import java.util.LinkedList;
import java.util.List;
import redgear.core.util.SimpleItem;
import redgear.morebackpacks.config.BackpackData;
import redgear.morebackpacks.core.BasicBackpack;

public class BackpackDataBuilder {
    private final String backpackKey;
    private final List<String> values = new LinkedList<String>();

    public BackpackDataBuilder(String backpackKey) {
        this.backpackKey = backpackKey;
    }

    public BackpackDataBuilder(BasicBackpack pack) {
        this.backpackKey = pack.getKey();
        for (SimpleItem item : pack.itemsList) {
            this.add(item.getName() + (item.meta == Short.MAX_VALUE ? "" : "@" + item.meta));
        }
    }

    public void add(String value) {
        this.values.add(value);
    }

    public BackpackData build() {
        BackpackData data = new BackpackData();
        data.setBackpackKey(this.backpackKey);
        data.setItems(this.values.toArray(new String[this.values.size()]));
        return data;
    }
}

