/*
 * Decompiled with CFR 0.152.
 */
package redgear.morebackpacks.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import forestry.api.storage.BackpackManager;
import forestry.api.storage.IBackpackDefinition;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.Arrays;
import java.util.Stack;
import redgear.morebackpacks.config.BackpackData;
import redgear.morebackpacks.core.MoreBackpacks;

public class ConfigReader {
    private static Gson gson = new GsonBuilder().setPrettyPrinting().serializeNulls().create();

    public static void read(String file) {
        ConfigReader.read(new File(file));
    }

    public static void read(File file) {
        try {
            BackpackData data = (BackpackData)gson.fromJson((Reader)new FileReader(file), BackpackData.class);
            IBackpackDefinition backpack = (IBackpackDefinition)BackpackManager.definitions.get(data.getBackpackKey());
            if (backpack == null) {
                MoreBackpacks.inst.logDebug("ConfigReader Can't Find Backpack: " + data.getBackpackKey());
                return;
            }
            data.addItems(backpack);
        }
        catch (Exception e) {
            MoreBackpacks.inst.myLogger.warn("ConfigReader doesn't understand file: " + file.getPath());
        }
    }

    public static void write(String file, BackpackData data) {
        ConfigReader.write(new File(file), data);
    }

    public static void write(File file, BackpackData data) {
        try {
            if (!file.exists()) {
                FileWriter writer = new FileWriter(file);
                gson.toJson((Object)data, (Appendable)writer);
                ((Writer)writer).close();
            } else {
                MoreBackpacks.inst.logDebug(new Object[]{"File: ", file, " already exists."});
            }
        }
        catch (Exception e) {
            MoreBackpacks.inst.logDebug("ConfigReader couldn't write file: " + file, (Throwable)e);
        }
    }

    public static void readAll(File directory) {
        Stack<File> files = new Stack<File>();
        files.add(directory);
        while (!files.empty()) {
            File next = (File)files.pop();
            if (next == null) continue;
            if (next.isDirectory()) {
                files.addAll(Arrays.asList(next.listFiles()));
                continue;
            }
            if (!next.getName().endsWith(".json")) continue;
            ConfigReader.read(next);
        }
    }
}

