/*
 * Decompiled with CFR 0.152.
 */
package redgear.morebackpacks.core;

import forestry.api.storage.IBackpackDefinition;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.StatCollector;
import redgear.core.util.SimpleItem;

public abstract class BasicBackpack
implements IBackpackDefinition {
    public Collection<SimpleItem> itemsList = new LinkedList<SimpleItem>();
    public SimpleItem backpackT1;
    public SimpleItem backpackT2;
    private final String unlocalname;

    protected BasicBackpack(String unlocalname) {
        this.unlocalname = unlocalname;
    }

    public void fill() {
    }

    public boolean modsLoaded() {
        return true;
    }

    public abstract ItemStack getCraftingItem();

    public void addItem(SimpleItem item) {
        if (!this.itemsList.contains(item)) {
            this.itemsList.add(item);
        }
    }

    public void addItem(ItemStack validItem) {
        this.addItem(new SimpleItem(validItem));
    }

    public void addValidItem(ItemStack validItem) {
        this.addItem(validItem);
    }

    public void addItem(Item validItem) {
        if (validItem != null) {
            this.addItem(new SimpleItem(validItem, Short.MAX_VALUE));
        }
    }

    public void addItem(Block validItem) {
        if (validItem != null) {
            this.addItem(new SimpleItem(validItem, Short.MAX_VALUE));
        }
    }

    public void addItem(Item validItem, int meta) {
        if (validItem != null) {
            this.addItem(new SimpleItem(validItem, meta));
        }
    }

    public void addItem(Block validItem, int meta) {
        if (validItem != null) {
            this.addItem(new SimpleItem(validItem, meta));
        }
    }

    public final Collection<ItemStack> getValidItems(EntityPlayer player) {
        ArrayList<ItemStack> stack = new ArrayList<ItemStack>(this.itemsList.size());
        for (SimpleItem item : this.itemsList) {
            stack.add(item.getStack());
        }
        return stack;
    }

    public boolean isValidItem(EntityPlayer player, ItemStack check) {
        return this.itemsList.contains(new SimpleItem(check));
    }

    public int getSecondaryColour() {
        return 0xFFFFFF;
    }

    public void addItemsFromMeta(Item item, int startMeta, int endMeta) {
        for (int i = startMeta; i <= endMeta; ++i) {
            this.addItem(item, i);
        }
    }

    public void addItemsFromMeta(Item item, int endMeta) {
        this.addItemsFromMeta(item, 0, endMeta);
    }

    public final String getKey() {
        return this.unlocalname.toLowerCase();
    }

    public final String getName() {
        return StatCollector.func_74838_a((String)("item.RedGear.MoreBackpacks.Backpack." + this.unlocalname + ".name"));
    }
}

