/*
 * Decompiled with CFR 0.152.
 */
package redgear.morebackpacks.core;

import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.registry.GameRegistry;
import forestry.api.recipes.RecipeManagers;
import forestry.api.storage.BackpackManager;
import forestry.api.storage.EnumBackpackType;
import forestry.api.storage.IBackpackDefinition;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidRegistry;
import redgear.core.mod.FileHelper;
import redgear.core.mod.ModUtils;
import redgear.core.util.SimpleItem;
import redgear.core.util.StringHelper;
import redgear.morebackpacks.backpacks.BackpackArtist;
import redgear.morebackpacks.backpacks.BackpackElectrician;
import redgear.morebackpacks.backpacks.BackpackFarmer;
import redgear.morebackpacks.backpacks.BackpackHydraulic;
import redgear.morebackpacks.backpacks.BackpackJewler;
import redgear.morebackpacks.backpacks.BackpackLogistic;
import redgear.morebackpacks.backpacks.BackpackMagician;
import redgear.morebackpacks.backpacks.BackpackMetallurgist;
import redgear.morebackpacks.backpacks.BackpackNuclear;
import redgear.morebackpacks.backpacks.BackpackProgrammer;
import redgear.morebackpacks.backpacks.BackpackRedstone;
import redgear.morebackpacks.backpacks.BackpackSurvival;
import redgear.morebackpacks.config.ConfigReader;
import redgear.morebackpacks.core.BasicBackpack;

@Mod(modid="redgear_morebackpacks", name="More Backpacks", version="2.2.1", dependencies="required-after:redgear_core;required-after:Forestry;")
public class MoreBackpacks
extends ModUtils {
    @Mod.Instance(value="redgear_morebackpacks")
    public static ModUtils inst;
    private SimpleItem wovenSilk;
    private File scriptDir;
    private final List<BasicBackpack> backpacks = new ArrayList<BasicBackpack>();

    public void PreInit(FMLPreInitializationEvent event) {
        this.scriptDir = new File(event.getModConfigurationDirectory(), StringHelper.concat((Object[])new Object[]{"RedGear", StringHelper.slash, "morebackpacks"}));
        this.createBackpack(new BackpackRedstone());
        this.createBackpack(new BackpackFarmer());
        this.createBackpack(new BackpackSurvival());
        this.createBackpack(new BackpackArtist());
        this.createBackpack(new BackpackMagician());
        this.createBackpack(new BackpackMetallurgist());
        this.createBackpack(new BackpackHydraulic());
        this.createBackpack(new BackpackJewler());
        this.createBackpack(new BackpackLogistic());
        this.createBackpack(new BackpackElectrician());
        this.createBackpack(new BackpackNuclear());
        this.createBackpack(new BackpackProgrammer());
    }

    protected void Init(FMLInitializationEvent event) {
    }

    public void PostInit(FMLPostInitializationEvent event) {
        this.wovenSilk = new SimpleItem(GameRegistry.findItem((String)"Forestry", (String)"craftingMaterial"), 3);
        if (!this.scriptDir.exists()) {
            this.scriptDir.mkdir();
        }
        for (BasicBackpack def : this.backpacks) {
            this.fillBackpack(def);
        }
        ConfigReader.readAll(this.scriptDir);
    }

    private void createBackpack(BasicBackpack def) {
        def.backpackT1 = new SimpleItem(BackpackManager.backpackInterface.addBackpack((IBackpackDefinition)def, EnumBackpackType.T1));
        def.backpackT2 = new SimpleItem(BackpackManager.backpackInterface.addBackpack((IBackpackDefinition)def, EnumBackpackType.T2));
        GameRegistry.registerItem((Item)def.backpackT1.getItem(), (String)(def.getKey() + "T1"));
        GameRegistry.registerItem((Item)def.backpackT2.getItem(), (String)(def.getKey() + "T2"));
        this.backpacks.add(def);
    }

    private void fillBackpack(BasicBackpack def) {
        File config;
        this.logDebug(new Object[]{"Creating backpack: ", def.getKey()});
        def.fill();
        ItemStack craftingItem = def.getCraftingItem();
        if (this.getBoolean(def.getKey()) && def.modsLoaded()) {
            if (craftingItem == null) {
                this.logDebug("Can't find special item for " + def.getName() + "!");
            } else {
                GameRegistry.addRecipe((ItemStack)def.backpackT1.getStack(), (Object[])new Object[]{"SWS", "XCX", "SWS", Character.valueOf('S'), Items.field_151007_F, Character.valueOf('W'), Blocks.field_150325_L, Character.valueOf('X'), craftingItem, Character.valueOf('C'), Blocks.field_150486_ae});
                RecipeManagers.carpenterManager.addRecipe(200, FluidRegistry.getFluidStack((String)"water", (int)1000), null, def.backpackT2.getStack(), new Object[]{"WXW", "WTW", "WWW", Character.valueOf('X'), Items.field_151045_i, Character.valueOf('W'), this.wovenSilk.getStack(), Character.valueOf('T'), def.backpackT1.getStack()});
            }
        }
        if (!(config = new File(this.scriptDir, def.getKey() + "Default.json")).exists()) {
            try {
                FileHelper.copy((InputStream)MoreBackpacks.class.getResourceAsStream("/assets/redgear_morebackpacks/config/" + def.getKey() + "Default.json"), (OutputStream)new FileOutputStream(config));
            }
            catch (FileNotFoundException e) {
                this.myLogger.error(StringHelper.concat((Object[])new Object[]{"Uh oh! Config for backpack", def.getKey(), " not found, but default config was missing too! I don't know what to do :'("}), (Throwable)e);
            }
            catch (IOException e) {
                this.myLogger.error(StringHelper.concat((Object[])new Object[]{"Uh oh! Config for backpack", def.getKey(), " not found, but there was a problem copying the default config from inside the mod's .jar. Maybe restarting will fix it?"}), (Throwable)e);
            }
        }
    }

    @Mod.EventHandler
    public void PreInitialization(FMLPreInitializationEvent event) {
        super.PreInitialization(event);
    }

    @Mod.EventHandler
    public void Initialization(FMLInitializationEvent event) {
        super.Initialization(event);
    }

    @Mod.EventHandler
    public void PostInitialization(FMLPostInitializationEvent event) {
        super.PostInitialization(event);
    }
}

