/*
 * Decompiled with CFR 0.152.
 */
package aom.client;

import aom.client.Inventory;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.common.IExtendedEntityProperties;

public class ExtendedPlayer
implements IExtendedEntityProperties {
    public static final String EXT_PROP_NAME = "ExtendedPlayer";
    public EntityPlayer player;
    private int currentMana;
    private int maxMana;
    public final Inventory inventory = new Inventory();

    public ExtendedPlayer(EntityPlayer player) {
        this.player = player;
        this.maxMana = 50;
        this.currentMana = 50;
    }

    public static final void register(EntityPlayer player) {
        player.registerExtendedProperties(EXT_PROP_NAME, (IExtendedEntityProperties)new ExtendedPlayer(player));
    }

    public static final ExtendedPlayer get(EntityPlayer player) {
        return (ExtendedPlayer)player.getExtendedProperties(EXT_PROP_NAME);
    }

    public void saveNBTData(NBTTagCompound compound) {
        NBTTagCompound properties = new NBTTagCompound();
        properties.func_74768_a("CurrentMana", this.currentMana);
        properties.func_74768_a("MaxMana", this.maxMana);
        compound.func_74782_a(EXT_PROP_NAME, (NBTBase)properties);
        this.inventory.writeToNBT(properties);
        this.inventory.readFromNBT(properties);
    }

    public void loadNBTData(NBTTagCompound compound) {
        NBTTagCompound properties = (NBTTagCompound)compound.func_74781_a(EXT_PROP_NAME);
        this.currentMana = properties.func_74762_e("CurrentMana");
        this.maxMana = properties.func_74762_e("MaxMana");
        System.out.println("[TUT PROPS] Mana from NBT: " + this.currentMana + "/" + this.maxMana);
        this.inventory.writeToNBT(properties);
        this.inventory.readFromNBT(properties);
    }

    public void init(Entity entity, World world) {
    }

    public boolean consumeMana(int amount) {
        boolean sufficient = amount <= this.currentMana;
        this.currentMana -= amount < this.currentMana ? amount : this.currentMana;
        return sufficient;
    }

    public void replenishMana() {
        this.currentMana = this.maxMana;
    }
}

